{{ *****************************************************
   *  Example1.1  : For "ET-BASE PX32 V1.0             *
   *                                                   *
   *  File Name   : Ex1.1_TV_TextRom.spin              *
   *  Compiler    : Propeller V1.06                    *
   *  Create By   : Sittiphol Yooyod (www.ett.co.th)   *
   *  Last Update : 28/January/2007                    *
   *  Function    : Display Text in ROM to TV          *                  
   *                                                   *
   ***************************************************** }}

  
CON

        _clkmode        = xtal1 + pll16x   ''Set PLL = x16
        _xinfreq        = 5_000_000        ''Crystal 5.0 Mhz ;System Clock =16x5=80Mhz


      ''---- Initial TV (Screen 640x480 Pixel) -----
      
       cols = 40
       rows = 13

       screensize = cols * rows
       lastrow = screensize - cols

       tv_count = 14

VAR

  long  col, row, color, flag
  
  word  screen[screensize]
  long  colors[8 * 2]

  long  tv_status     '0/1/2 = off/invisible/visible              read-only   (14 longs)
  long  tv_enable     '0/non-0 = off/on                           write-only
  long  tv_pins       '%pppmmmm = pin group, pin group mode       write-only
  long  tv_mode       '%tccip = tile,chroma,interlace,ntsc/pal    write-only
  long  tv_screen     'pointer to screen (words)                  write-only      
  long  tv_colors     'pointer to colors (longs)                  write-only                            
  long  tv_ht         'horizontal tiles                           write-only                            
  long  tv_vt         'vertical tiles                             write-only                            
  long  tv_hx         'horizontal tile expansion                  write-only                            
  long  tv_vx         'vertical tile expansion                    write-only                            
  long  tv_ho         'horizontal offset                          write-only                            
  long  tv_vo         'vertical offset                            write-only                            
  long  tv_broadcast  'broadcast frequency (Hz)                   write-only                            
  long  tv_auralcog   'aural fm cog                               write-only                            
  
OBJ

        tv    : "tv"                ''Include Function in File TV.spin


PUB main |count0,count1

  start(12)                            ''Start TV PIN 12..15
 
  str(string("...ETT DEMO TEXT(16x32) ON DISPLAY TV...",13))  '' Sent Megsage ON TV
 
  out($0C)                                                    '' Set Color 
  out($03)                                                    '' Text:Violet,Back Ground Text:Black 
  str(string(13,"          Example Text In ROM          ",13))'' Sent Data Text ON TV 

  out($0C)                                                    '' Set Color 
  out($07)                                                    '' Text:Pink,Back Ground Text:Green 
  str(string(" A B C D E F G H I J K L M N O P Q R S   T U V W X Y Z ")) '' Sent Megsage ON TV
  repeat 25
   out(" ")  ''Space
  
  out($0C)                                                    '' Set Color 
  out($04)                                                    '' Text:Green,Back Ground Text:White 
  str(string(" a b c d e f g h i j k l m n o p q r s   t u v w x y z ")) '' Sent Megsage ON TV   
  repeat 25
   out(" ")  ''Space


  out($0C)                                                    '' Set Color 
  out($02)                                                    '' Text:Sky-Blue,Back Ground Text:Red 
  str(string(" 0 1 2 3 4 5 6 7 8 9 ! @ # $ % & * ( =   - + [ { < ? /  ")) '' Sent Megsage ON TV   
  repeat 24
   out(" ")  ''Space
    
  out($0C)                                                    '' Set Color 
  out($06)                                                    '' Text:Org,Back Ground Text:Back 
  str(string(13,"            WWW.ETT.CO.TH            "))     '' Sent Megsage ON TV   
  
  out($0C)                                                    '' Set Color 
  out($05)                                                    '' Text:Yellow,Back Ground Text:Black 
  
  repeat
    out($0A)     '' Set Position Text Axle-X
    out(3)       '' X-Position = Coloum 3 
    out($0B)     '' Set Position Text Axle-Y
    out(2)       '' Y-Position = Line 2
    hex(count0++,4)    '' Convert Hex 4 digit
     
    out($0A)     '' Set Position Text Axle-X
    out(33)      '' X-Position = Coloum 33 
    out($0B)     '' Set Position Text Axle-Y
    out(2)       '' Y-Position = Line 2
    hex(count1--,4)
      
    WaitCnt(40_000_000 + Cnt) ''delay 500 ms   

    
'----------------------------- SUB Program -------------------------------------

  
PUB start(basepin) : okay

'' Start terminal - starts a cog
'' returns false if no cog available

  setcolors(@color0)                         'Set Start Color Screen Black and Text white
  out(0)
  
  longmove(@tv_status, @tv_params, tv_count)
  tv_pins := (basepin & $38) << 1 | (basepin & 4 == 4) & %0101
  tv_screen := @screen
  tv_colors := @colors
  
  okay := tv.start(@tv_status)


PUB stop

'' Stop terminal - frees a cog

  tv.stop


PUB str(stringptr)

'' Print a zero-terminated string

  repeat strsize(stringptr)
    out(byte[stringptr++])


PUB dec(value) | i

'' Print a decimal number

  if value < 0
    -value
    out("-")

  i := 1_000_000_000

  repeat 10
    if value => i
      out(value / i + "0")
      value //= i
      result~~
    elseif result or i == 1
      out("0")
    i /= 10


PUB hex(value, digits)

'' Print a hexadecimal number

  value <<= (8 - digits) << 2
  repeat digits
    out(lookupz((value <-= 4) & $F : "0".."9", "A".."F"))


PUB bin(value, digits)

'' Print a binary number

  value <<= 32 - digits
  repeat digits
    out((value <-= 1) & 1 + "0")


PUB out(c) | i, k

'' Output a character
''
''     $00 = clear screen
''     $01 = home
''     $08 = backspace
''     $09 = tab (8 spaces per)
''     $0A = set X position (X follows)
''     $0B = set Y position (Y follows)
''     $0C = set color (color follows)
''     $0D = return
''  others = printable characters

  case flag
    $00: case c
           $00: wordfill(@screen, $220, screensize)
                col := row := 0
           $01: col := row := 0
           $08: if col
                  col--
           $09: repeat
                  print(" ")
                while col & 7
           $0A..$0C: flag := c
                     return
           $0D: newline
           other: print(c)
    $0A: col := c // cols
    $0B: row := c // rows
    $0C: color := c & 7
  flag := 0


  
PUB setcolors(colorptr) | i, fore, back

'' Override default color palette
'' colorptr must point to a list of up to 8 colors
'' arranged as follows:
''
''               fore   back
''               ------------
'' palette  byte color, color     'color 0
''          byte color, color     'color 1
''          byte color, color     'color 2
''          ...

  repeat i from 0 to 7
    fore := byte[colorptr][i << 1]
    back := byte[colorptr][i << 1 + 1]
    colors[i << 1]     := fore << 24 + back << 16 + fore << 8 + back
    colors[i << 1 + 1] := fore << 24 + fore << 16 + back << 8 + back


PRI print(c)

  screen[row * cols + col] := (color << 1 + c & 1) << 10 + $200 + c & $FE
  if ++col == cols
    newline


PRI newline | i

  col := 0
  if ++row == rows
    row--
    wordmove(@screen, @screen[cols], lastrow)   'scroll lines
    wordfill(@screen[lastrow], $220, cols)      'clear new line



DAT

tv_params               long    0               'status
                        long    1               'enable
                        long    0               'pins
                        long    %10010          'mode
                        long    0               'screen
                        long    0               'colors
                        long    cols            'hc
                        long    rows            'vc
                        long    4               'hx
                        long    1               'vx
                        long    0               'ho
                        long    0               'vo
                        long    0               'broadcast
                        long    0               'auralcog



                      'Text Color  'Screen&Back-Ground Colour
color0            byte     $07,        $01    '0    white    Text  / Black Screen 
                  byte     $01,        $07    '1    Black     Text / white Screen
                  byte     $4E,        $DC    '2    Sky-blue Text  / Red Screen
                  byte     $1E,        $01    '3    Violet   Teat  / Black Screen      
                  byte     $7C,        $07    '4    Green    Text  / white Screen
                  byte     $9E,        $01    '5    Yellow   Text  / Black Screen
                  byte     $38,        $01    '6    Orange   Text  / Black Screen
                  byte     $EE,        $7C    '7    Pink     Text  / Green Screen